/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.factories;

import com.badlogic.gdx.math.RandomXS128;
import com.google.inject.Inject;
import java.util.Random;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpecies;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesDictionary;

public class PlantEntityAttributesFactory {
    private final PlantSpeciesDictionary speciesDictionary;

    @Inject
    public PlantEntityAttributesFactory(PlantSpeciesDictionary speciesDictionary) {
        this.speciesDictionary = speciesDictionary;
    }

    public PlantEntityAttributes randomTreeByName(String speciesName) {
        RandomXS128 random = new RandomXS128();
        PlantEntityAttributes attributes = new PlantEntityAttributes(((Random)random).nextLong());
        attributes.setCurrentTileHeight(((Random)random).nextInt(2) + 3);
        attributes.setSpecies(this.speciesDictionary.getByName(speciesName));
        attributes.setGrowthRate(0.9f + ((Random)random).nextFloat() * 0.2f);
        attributes.setLeafColorChangeRate(0.8f + ((Random)random).nextFloat() * 0.4f);
        attributes.setLeafDropAmount(0.9999f - ((Random)random).nextFloat() * 0.2f);
        return attributes;
    }

    public PlantEntityAttributes newPlantBySpecies(PlantSpecies plantSpecies, Random random) {
        PlantEntityAttributes attributes = new PlantEntityAttributes(random.nextLong());
        attributes.setCurrentTileHeight(1);
        attributes.setSpecies(plantSpecies);
        if (plantSpecies.getFruit() != null) {
            attributes.setFruitState(PlantEntityAttributes.FruitState.BARE);
        }
        attributes.setGrowthAmount(0.0f);
        attributes.setGrowthRate(0.9f + random.nextFloat() * 0.2f);
        attributes.setLeafColorChangeRate(0.8f + random.nextFloat() * 0.4f);
        attributes.setLeafDropAmount(0.9999f - random.nextFloat() * 0.2f);
        return attributes;
    }

    public PlantEntityAttributes randomShrubByName(String speciesName) {
        RandomXS128 random = new RandomXS128();
        PlantEntityAttributes attributes = new PlantEntityAttributes(((Random)random).nextLong());
        attributes.setCurrentTileHeight(1);
        PlantSpecies species = this.speciesDictionary.getByName(speciesName);
        attributes.setSpecies(species);
        if (species.getFruit() != null) {
            attributes.setFruitState(PlantEntityAttributes.FruitState.RIPENING);
        }
        attributes.setGrowthRate(0.9f + ((Random)random).nextFloat() * 0.2f);
        attributes.setLeafColorChangeRate(0.8f + ((Random)random).nextFloat() * 0.4f);
        attributes.setLeafDropAmount(0.9999f - ((Random)random).nextFloat() * 0.2f);
        return attributes;
    }
}

